/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.MaterialForm;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.Material")
public class Material {
    private static final TreeMap<IMaterial, Material> MATERIAL_WRAPPERS = new TreeMap();
    private final IMaterial material;

    public static Material getMaterialWrapper(IMaterial material) {
        return MATERIAL_WRAPPERS.computeIfAbsent(material, Material::new);
    }

    private Material(IMaterial material) {
        this.material = material;
    }

    public IMaterial getInternal() {
        return this.material;
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.material.getName();
    }

    @ZenCodeType.Getter(value="type")
    public String getType() {
        return this.material.getType().getName();
    }

    @ZenCodeType.Getter(value="alternativeNames")
    public String[] getAlternativeNames() {
        return this.material.getAlternativeNames().toArray(new String[0]);
    }

    @ZenCodeType.Method
    public Material getExtra(int index) {
        return new Material(this.material.getExtra(index));
    }

    @ZenCodeType.Method
    public boolean hasExtra(int index) {
        return this.material.hasExtra(index);
    }

    @ZenCodeType.Method
    public MCTag getItemTag(String prefix) {
        return this.getTag(Registry.f_122904_.getRegistryName(), prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getItemTag(String prefix, String tagSeperator) {
        return this.getTag(Registry.f_122904_.getRegistryName(), prefix, tagSeperator);
    }

    @ZenCodeType.Method
    public MCTag getFluidTag(String prefix) {
        return this.getTag(Registry.f_122899_.getRegistryName(), prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getFluidTag(String prefix, String tagSeperator) {
        return this.getTag(Registry.f_122899_.getRegistryName(), prefix, tagSeperator);
    }

    @ZenCodeType.Method
    public MCTag getTag(ResourceLocation registry, String prefix) {
        return this.getTag(registry, prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getTag(ResourceLocation registry, String prefix, String tagSeperator) {
        return CraftTweakerTagRegistry.INSTANCE.tagManager(registry).tag(MiscHelper.INSTANCE.getTagLocation(prefix, this.material.getName(), tagSeperator));
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getTagLocation(prefix, this.material.getName()), count);
        return new MCItemStack(stack);
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String prefix) {
        return this.getItemStack(prefix, 1);
    }

    @ZenCodeType.Method
    public IFluidStack getFluidStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getTagLocation(prefix, this.material.getName()), count);
        return new MCFluidStack(stack);
    }

    @ZenCodeType.Method
    public MaterialForm getMaterialForm(Form form) {
        if (!form.containsMaterial(this)) {
            return null;
        }
        return MaterialForm.getMaterialFormWrapper(form.getInternal(), this.material);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Material)) {
            return false;
        }
        Material other = (Material)obj;
        return this.material == other.material;
    }

    public int hashCode() {
        return this.material.hashCode() + 7;
    }
}

